/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1995  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/ 
`delay_mode_path
`timescale 1 ns / 1 ns
`ifdef SYNTH
`else
`celldefine
`endif
module lpm_ram_io ( data, inclock, outclock, we, memenab, outenab, address) ;

  parameter lpm_type = "lpm_ram_io" ;
  parameter lpm_width  = 1 ;
  parameter lpm_widthad = 1 ;
  parameter lpm_numwords = 2 ;
  parameter lpm_file       = "UNUSED" ;
  parameter lpm_indata     = "REGISTERED" ;
  parameter lpm_outdata    = "REGISTERED" ;
  parameter lpm_addr_control = "REGISTERED" ;
  parameter polar_data     = "NORMAL" ;
  parameter polar_inclock  = "NORMAL" ;
  parameter polar_outclock = "NORMAL" ;
  parameter polar_we       = "NORMAL" ;
  parameter polar_memenab  = "NORMAL" ;
  parameter polar_outenab  = "NORMAL" ;
  parameter polar_address  = "NORMAL" ;

  input  [lpm_widthad-1:0] address ;
  input  inclock, outclock, we ;
  input  memenab ;
  input  outenab ;
  inout  [lpm_width-1:0] data ;


  // inernal reg 
  reg   [lpm_width-1:0] memRAM [lpm_numwords-1:0];
  reg   [lpm_width-1:0] tmp_io ;
  reg   [lpm_width-1:0] pdata ;
  reg   [lpm_widthad-1:0] paddress ;
  reg   [lpm_widthad-1:0] paddress_in ;
  reg   pinclock, poutclock, pwe, pwe_in ;
  reg   pmemenab, pmemenab_in, poutenab ;
  reg   [lpm_width-1:0] ONES, ZEROS, UNKNOWN, HiZ ;
  reg [8*256:1] ram_initf ;
  integer i ;

  pullup   P3 ( memenab) ;
  pullup   P4 ( we) ;
  pullup   P5 ( outenab) ;


  function ValidAddress ;
	input [lpm_widthad-1:0] paddress ;
	begin
		ValidAddress = 1'b0 ;
		if(^paddress ==='bx)
			$display("%d:Error: Invalid address.", $time) ;
		else if(paddress >= lpm_numwords)
			$display("%d:Error: Address out of bound on RAM.", $time) ;
		else
			ValidAddress = 1'b1 ;
	end
  endfunction
		
  initial
  begin
    // check for number of words out of bound.
    if(lpm_numwords > (1 << lpm_widthad))
	begin
        $display("Error! Too many words defined.\n");
		$stop;
	end

    // check if lpm_indata or lpm_addr_control is set to registered
    // inclock must be used.
    if(((lpm_indata === "REGISTERED") || (lpm_addr_control === "REGISTERED")) && (inclock === 1'bz))
    begin
        $display("Error! inclock = 1'bz.  Inclock pin must be used.\n");
    end
 
    // check if lpm_outdata, outclock must be used
    if((lpm_outdata === "REGISTERED") && (outclock === 1'bz))
    begin
        $display("Error! lpm_outdata is REGISTERED, outclock = 1'bz.  Outclock pin must be used.\n");  
    end
 
	for(i=0; i < lpm_width; i=i+1)
	begin
		ONES[i] = 1'b1 ;
		ZEROS[i] = 1'b0 ;
		UNKNOWN[i] = 1'bX ;
		HiZ[i] = 1'bZ ;
	end	
	
	for(i = 0; i < lpm_numwords; i=i+1)
		memRAM[i] = ZEROS ;

    // load data to the RAM
    if(lpm_file != "UNUSED")
    begin
`ifdef SYNTH
`else
     $convert_hex2ver(lpm_file, lpm_width, ram_initf);
`endif
        $readmemh(ram_initf, memRAM);
    end
  end

  always @(inclock)
      pinclock <= #1 (polar_inclock == "INVERT")?~inclock:inclock;
    
  always @(outclock)
      poutclock <= #1 (polar_outclock == "INVERT")?~outclock:outclock;
    
  always @(memenab)
	  pmemenab_in <= #1 (polar_memenab == "INVERT")?~memenab:memenab;
    
  always @(outenab)
	  poutenab <= #1 (polar_outenab == "INVERT")?~outenab:outenab;
    
  always @(data or address or we)
  begin
    pwe_in <= #1 (polar_we == "INVERT")?~we:we;
	pdata    <= #1 (polar_data == "INVERT")?~data:data;
	paddress_in <= #1 (polar_address == "INVERT")?~address:address;
  end
	
  always @( pdata or paddress_in or pwe_in or pmemenab_in or poutenab )
  begin :block_a
  	if(lpm_addr_control === "UNREGISTERED")
    begin
       	pwe = pwe_in ;
       	paddress = paddress_in ;
       	pmemenab = pmemenab_in ;
		
		if (!pmemenab || !outenab)
			tmp_io = HiZ ;
    end
    
	
	if (pmemenab && pwe && outenab)
	begin
		$display("%d:Error: Illegal state.", $time) ;
	end
	else if (pmemenab && !pwe && poutenab)
	begin
		if(lpm_outdata === "UNREGISTERED")
		begin
			if(ValidAddress(paddress))
				tmp_io = memRAM[paddress] ;
			else
				tmp_io = UNKNOWN ;
		end
	end
    else if (pmemenab && pwe && !poutenab)
 	begin
		if(lpm_indata == "UNREGISTERED")
		begin
			if(ValidAddress(paddress))
				memRAM[paddress] = pdata ;
		end
	end

  end

  always @(posedge pinclock)
    begin :block_b
	  if(lpm_addr_control === "REGISTERED")
      	begin
      		pwe = pwe_in ;
      		paddress = paddress_in ;
      		pmemenab = pmemenab_in ;
      	end

	  if (!pmemenab || !outenab)
			tmp_io = HiZ ;

      if (pmemenab && pwe && !outenab)
		begin
			if(lpm_indata === "REGISTERED")
			begin
				if(ValidAddress(paddress))
					memRAM[paddress] = pdata ;
				else
					tmp_io = UNKNOWN ;
			end
		end
	
	  if(memenab && !pwe && outenab && lpm_outdata === "UNREGISTERED")
			tmp_io = memRAM[paddress] ;
  end

  always @(posedge poutclock)
    begin :block_c
        if(lpm_outdata === "REGISTERED")
        begin
      		if (pmemenab && !pwe && outenab)
			begin
				if(ValidAddress(paddress))
					#0 tmp_io = memRAM[paddress] ;
				else
					tmp_io = UNKNOWN ;
			end
		end
    end
 
  assign data = (polar_data == "INVERT")?~tmp_io:tmp_io ;

endmodule // lpm_ram_io
`ifdef SYNTH
`else
`endcelldefine
`endif
 
